/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.client.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.Codec;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.StringRepresentableArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.config.ModConfigs;
import net.neoforged.neoforge.server.command.ModIdArgument;

public class NeoForgeConfigCommand {
    private static final Dynamic2CommandExceptionType ERROR_NO_CONFIG = new Dynamic2CommandExceptionType((modId, type) -> Component.translatable((String)"commands.config.noconfig", (Object[])new Object[]{modId, type}));

    public static <T extends Enum<T>, P extends SharedSuggestionProvider> void register(CommandDispatcher<P> dispatcher, BiConsumer<P, Component> feedbackSender) {
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"config").then(RequiredArgumentBuilder.argument((String)"mod", (ArgumentType)new ModIdArgument(){

            public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
                return SharedSuggestionProvider.suggest(ModList.get().applyForEachModContainer(ModContainer::getModId).filter(NeoForgeConfigCommand::anyModConfigsExist), (SuggestionsBuilder)builder);
            }
        }).then(RequiredArgumentBuilder.argument((String)"type", NeoForgeConfigCommand.enumConstant(Type.class)).executes(commandContext -> NeoForgeConfigCommand.showFile(component -> feedbackSender.accept((Object)((SharedSuggestionProvider)commandContext.getSource()), (Component)component), (String)commandContext.getArgument("mod", String.class), ((Type)((Object)((Object)commandContext.getArgument("type", Type.class)))).unwrap())))));
    }

    public static <T extends Enum<T>> StringRepresentableArgument<T> enumConstant(Class<? extends T> enumClazz) {
        return new StringRepresentableArgument<T>((Codec)StringRepresentable.fromEnum(enumClazz::getEnumConstants), enumClazz::getEnumConstants){};
    }

    private static boolean anyModConfigsExist(String modId) {
        return Stream.of(ModConfig.Type.values()).flatMap(type -> ModConfigs.getConfigFileNames((String)modId, (ModConfig.Type)type).stream()).findAny().isPresent();
    }

    private static int showFile(Consumer<Component> feedbackSender, String modId, ModConfig.Type type) throws CommandSyntaxException {
        List configFileNames = ModConfigs.getConfigFileNames((String)modId, (ModConfig.Type)type);
        if (configFileNames.isEmpty()) {
            throw ERROR_NO_CONFIG.create((Object)modId, (Object)type.name().toLowerCase(Locale.ROOT));
        }
        configFileNames.stream().map(File::new).map(NeoForgeConfigCommand::fileComponent).forEach(component -> feedbackSender.accept((Component)Component.translatable((String)"commands.config.getwithtype", (Object[])new Object[]{modId, type.name().toLowerCase(Locale.ROOT), component})));
        return configFileNames.size();
    }

    private static Component fileComponent(File file) {
        return Component.literal((String)file.getName()).withStyle(ChatFormatting.UNDERLINE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath())));
    }

    private static enum Type implements StringRepresentable
    {
        COMMON,
        CLIENT,
        SERVER,
        STARTUP;


        public ModConfig.Type unwrap() {
            return ModConfig.Type.valueOf((String)this.name());
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

