/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.gui.v2.components;

import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.jetbrains.annotations.Nullable;

public final class ScreenElementPositioner {
    private ScreenElementPositioner() {
    }

    public static boolean tryPositionElement(LayoutElement element, List<? extends GuiEventListener> widgets, String ... translationKeys) {
        return ScreenElementPositioner.tryPositionElement(element, widgets, false, translationKeys);
    }

    public static boolean tryPositionElement(LayoutElement element, List<? extends GuiEventListener> widgets, boolean tryPositionRightFirst, String ... translationKeys) {
        return ScreenElementPositioner.tryPositionElement(element, widgets, tryPositionRightFirst, 4, translationKeys);
    }

    public static boolean tryPositionElement(LayoutElement element, List<? extends GuiEventListener> widgets, boolean tryPositionRightFirst, int horizontalOffset, String ... translationKeys) {
        int originalX = element.getX();
        int originalY = element.getY();
        for (String translationKey : translationKeys) {
            LayoutElement otherElement = ScreenElementPositioner.findElement(widgets, translationKey);
            if (otherElement == null) continue;
            ScreenElementPositioner.moveElementToOther(element, otherElement, tryPositionRightFirst, horizontalOffset);
            if (ScreenElementPositioner.noOverlapWithExisting(widgets, element)) {
                return true;
            }
            ScreenElementPositioner.moveElementToOther(element, otherElement, !tryPositionRightFirst, horizontalOffset);
            if (!ScreenElementPositioner.noOverlapWithExisting(widgets, element)) continue;
            return true;
        }
        element.setPosition(originalX, originalY);
        return false;
    }

    private static void moveElementToOther(LayoutElement element, LayoutElement otherElement, boolean tryPositionRightFirst, int horizontalOffset) {
        if (tryPositionRightFirst) {
            ScreenElementPositioner.moveToRight(element, otherElement, horizontalOffset);
        } else {
            ScreenElementPositioner.moveToLeft(element, otherElement, horizontalOffset);
        }
    }

    private static void moveToLeft(LayoutElement element, LayoutElement otherElement, int horizontalOffset) {
        element.setPosition(otherElement.getX() - element.getWidth() - horizontalOffset, otherElement.getY());
    }

    private static void moveToRight(LayoutElement element, LayoutElement otherElement, int horizontalOffset) {
        element.setPosition(otherElement.getX() + otherElement.getWidth() + horizontalOffset, otherElement.getY());
    }

    private static boolean noOverlapWithExisting(List<? extends GuiEventListener> widgets, LayoutElement element) {
        for (GuiEventListener guiEventListener : widgets) {
            if (!(guiEventListener instanceof LayoutElement)) continue;
            LayoutElement otherElement = (LayoutElement)guiEventListener;
            if (element.getRectangle().intersection(otherElement.getRectangle()) == null) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static LayoutElement findElement(List<? extends GuiEventListener> widgets, String translationKey) {
        for (GuiEventListener guiEventListener : widgets) {
            AbstractWidget widget;
            if (!(guiEventListener instanceof AbstractWidget) || !ScreenElementPositioner.matchesTranslationKey(widget = (AbstractWidget)guiEventListener, translationKey)) continue;
            return widget;
        }
        return null;
    }

    private static boolean matchesTranslationKey(AbstractWidget widget, String translationKey) {
        TranslatableContents contents;
        ComponentContents message = widget.getMessage().getContents();
        return message instanceof TranslatableContents && (contents = (TranslatableContents)message).getKey().equals(translationKey);
    }
}

