/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.badmobs;

import net.darkhax.badmobs.config.Configuration;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;

@Mod(value="badmobs")
public class BadMobs {
    private Configuration config;

    public BadMobs(IEventBus modBus) {
        modBus.addListener(EventPriority.LOWEST, this::afterEntityRegistered);
        NeoForge.EVENT_BUS.addListener(this::onSpawnFinalized);
        NeoForge.EVENT_BUS.addListener(this::onEntityJoinWorld);
    }

    private void afterEntityRegistered(RegisterSpawnPlacementsEvent event) {
        this.config = new Configuration();
    }

    private void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity = event.getEntity();
        if (entity instanceof Mob && !(mob = (Mob)entity).level().isClientSide() && this.config != null && !this.config.allowSpawn((Entity)mob, mob.getSpawnType())) {
            event.setCanceled(true);
            event.getEntity().discard();
        }
    }

    private void onSpawnFinalized(FinalizeSpawnEvent event) {
        if (this.config != null && !event.getEntity().level().isClientSide() && !this.config.allowSpawn((Entity)event.getEntity(), event.getSpawnType())) {
            event.setSpawnCancelled(true);
        }
    }
}

