/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.AllDataComponents;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.blueprint.BlueprintOverlayRenderer;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackBlockItem;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackPaver;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecs;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.render.BindableTexture;
import net.createmod.catnip.theme.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TrackPlacement {
    public static PlacementInfo cached;
    static BlockPos hoveringPos;
    static boolean hoveringMaxed;
    static int hoveringAngle;
    static ItemStack lastItem;
    static int extraTipWarmup;
    static LerpedFloat animation;
    static int lastLineCount;
    static BlockPos hintPos;
    static int hintAngle;
    static Couple<List<BlockPos>> hints;

    public static PlacementInfo tryConnect(Level level, Player player, BlockPos pos2, BlockState state2, ItemStack stack, boolean girder, boolean maximiseTurn) {
        boolean shouldPave;
        double[] sTest;
        boolean slope;
        double[] intersect;
        TrackBlockEntity tbe;
        Vec3 lookVec = player.getLookAngle();
        int lookAngle = (int)(22.5 + (double)(AngleHelper.deg((double)Mth.atan2((double)lookVec.z, (double)lookVec.x)) % 360.0f)) / 8;
        int maxLength = (Integer)AllConfigs.server().trains.maxTrackPlacementLength.get();
        if (level.isClientSide && cached != null && pos2.equals((Object)hoveringPos) && stack.equals(lastItem) && hoveringMaxed == maximiseTurn && lookAngle == hoveringAngle) {
            return cached;
        }
        PlacementInfo info = new PlacementInfo(TrackMaterial.fromItem(stack.getItem()));
        hoveringMaxed = maximiseTurn;
        hoveringAngle = lookAngle;
        hoveringPos = pos2;
        lastItem = stack;
        cached = info;
        ITrackBlock track = (ITrackBlock)state2.getBlock();
        Pair<Vec3, Direction.AxisDirection> nearestTrackAxis = track.getNearestTrackAxis((BlockGetter)level, pos2, state2, lookVec);
        Vec3 axis2 = ((Vec3)nearestTrackAxis.getFirst()).scale(nearestTrackAxis.getSecond() == Direction.AxisDirection.POSITIVE ? -1.0 : 1.0);
        Vec3 normal2 = track.getUpNormal((BlockGetter)level, pos2, state2).normalize();
        Vec3 normedAxis2 = axis2.normalize();
        Vec3 end2 = track.getCurveStart((BlockGetter)level, pos2, state2, axis2);
        ConnectingFrom connectingFrom = (ConnectingFrom)stack.get(AllDataComponents.TRACK_CONNECTING_FROM);
        BlockPos pos1 = connectingFrom.pos();
        Vec3 axis1 = connectingFrom.axis();
        Vec3 normedAxis1 = axis1.normalize();
        Vec3 end1 = connectingFrom.end();
        Vec3 normal1 = connectingFrom.normal();
        BlockState state1 = level.getBlockState(pos1);
        if (level.isClientSide) {
            info.end1 = end1;
            info.end2 = end2;
            info.normal1 = normal1;
            info.normal2 = normal2;
            info.axis1 = axis1;
            info.axis2 = axis2;
        }
        if (pos1.equals((Object)pos2)) {
            return info.withMessage("second_point");
        }
        if (pos1.distSqr((Vec3i)pos2) > (double)(maxLength * maxLength)) {
            return info.withMessage("too_far").tooJumbly();
        }
        if (!state1.hasProperty((Property)TrackBlock.HAS_BE)) {
            return info.withMessage("original_missing");
        }
        BlockEntity blockEntity = level.getBlockEntity(pos2);
        if (blockEntity instanceof TrackBlockEntity && (tbe = (TrackBlockEntity)blockEntity).isTilted()) {
            return info.withMessage("turn_start");
        }
        if (axis1.dot(end2.subtract(end1)) < 0.0) {
            axis1 = axis1.scale(-1.0);
            normedAxis1 = normedAxis1.scale(-1.0);
            end1 = track.getCurveStart((BlockGetter)level, pos1, state1, axis1);
            if (level.isClientSide) {
                info.end1 = end1;
                info.axis1 = axis1;
            }
        }
        boolean parallel = (intersect = VecHelper.intersect((Vec3)end1, (Vec3)end2, (Vec3)normedAxis1, (Vec3)normedAxis2, (Direction.Axis)Direction.Axis.Y)) == null;
        boolean skipCurve = false;
        if (parallel && normedAxis1.dot(normedAxis2) > 0.0 || !parallel && (intersect[0] < 0.0 || intersect[1] < 0.0)) {
            axis2 = axis2.scale(-1.0);
            normedAxis2 = normedAxis2.scale(-1.0);
            end2 = track.getCurveStart((BlockGetter)level, pos2, state2, axis2);
            if (level.isClientSide) {
                info.end2 = end2;
                info.axis2 = axis2;
            }
        }
        Vec3 cross2 = normedAxis2.cross(new Vec3(0.0, 1.0, 0.0));
        double a1 = Mth.atan2((double)normedAxis2.z, (double)normedAxis2.x);
        double a2 = Mth.atan2((double)normedAxis1.z, (double)normedAxis1.x);
        double angle = a1 - a2;
        double ascend = end2.subtract((Vec3)end1).y;
        double absAscend = Math.abs(ascend);
        boolean bl = slope = !normal1.equals((Object)normal2);
        if (level.isClientSide) {
            Vec3 offset1 = axis1.scale((double)info.end1Extent);
            Vec3 offset2 = axis2.scale((double)info.end2Extent);
            BlockPos targetPos1 = pos1.offset((Vec3i)BlockPos.containing((Position)offset1));
            BlockPos targetPos2 = pos2.offset((Vec3i)BlockPos.containing((Position)offset2));
            info.curve = new BezierConnection((Couple<BlockPos>)Couple.create((Object)targetPos1, (Object)targetPos2), (Couple<Vec3>)Couple.create((Object)end1.add(offset1), (Object)end2.add(offset2)), (Couple<Vec3>)Couple.create((Object)normedAxis1, (Object)normedAxis2), (Couple<Vec3>)Couple.create((Object)normal1, (Object)normal2), true, girder, TrackMaterial.fromItem(stack.getItem()));
        }
        double dist = 0.0;
        if (parallel && (sTest = VecHelper.intersect((Vec3)end1, (Vec3)end2, (Vec3)normedAxis1, (Vec3)cross2, (Direction.Axis)Direction.Axis.Y)) != null) {
            double t = Math.abs(sTest[0]);
            double u = Math.abs(sTest[1]);
            skipCurve = Mth.equal((double)u, (double)0.0);
            if (!skipCurve && sTest[0] < 0.0) {
                return info.withMessage("perpendicular").tooJumbly();
            }
            if (skipCurve) {
                dist = VecHelper.getCenterOf((Vec3i)pos1).distanceTo(VecHelper.getCenterOf((Vec3i)pos2));
                info.end1Extent = (int)Math.round((dist + 1.0) / axis1.length());
            } else {
                double targetT;
                if (!Mth.equal((double)ascend, (double)0.0) || normedAxis1.y != 0.0) {
                    return info.withMessage("ascending_s_curve");
                }
                double d = targetT = u <= 1.0 ? 3.0 : u * 2.0;
                if (t < targetT) {
                    return info.withMessage("too_sharp");
                }
                if (t > targetT) {
                    int correction = (int)((t - targetT) / axis1.length());
                    info.end1Extent = maximiseTurn ? 0 : correction / 2 + correction % 2;
                    int n = info.end2Extent = maximiseTurn ? 0 : correction / 2;
                }
            }
        }
        if (slope) {
            double dist2;
            if (!skipCurve) {
                return info.withMessage("slope_turn");
            }
            if (Mth.equal((double)normal1.dot(normal2), (double)0.0)) {
                return info.withMessage("opposing_slopes");
            }
            if ((axis1.y < 0.0 || axis2.y > 0.0) && ascend > 0.0) {
                return info.withMessage("leave_slope_ascending");
            }
            if ((axis1.y > 0.0 || axis2.y < 0.0) && ascend < 0.0) {
                return info.withMessage("leave_slope_descending");
            }
            skipCurve = false;
            info.end1Extent = 0;
            info.end2Extent = 0;
            Direction.Axis plane = Mth.equal((double)axis1.x, (double)0.0) ? Direction.Axis.X : Direction.Axis.Z;
            intersect = VecHelper.intersect((Vec3)end1, (Vec3)end2, (Vec3)normedAxis1, (Vec3)normedAxis2, (Direction.Axis)plane);
            double dist1 = Math.abs(intersect[0] / axis1.length());
            if (dist1 > (dist2 = Math.abs(intersect[1] / axis2.length()))) {
                info.end1Extent = (int)Math.round(dist1 - dist2);
            }
            if (dist2 > dist1) {
                info.end2Extent = (int)Math.round(dist2 - dist1);
            }
            double turnSize = Math.min(dist1, dist2);
            if (intersect[0] < 0.0 || intersect[1] < 0.0) {
                return info.withMessage("too_sharp").tooJumbly();
            }
            if (turnSize < 2.0) {
                return info.withMessage("too_sharp");
            }
            if (turnSize > 2.0 && !maximiseTurn) {
                info.end1Extent = (int)((double)info.end1Extent + (turnSize - 2.0));
                info.end2Extent = (int)((double)info.end2Extent + (turnSize - 2.0));
                turnSize = 2.0;
            }
        }
        if (skipCurve && !Mth.equal((double)ascend, (double)0.0)) {
            int hDistance = info.end1Extent;
            if (axis1.y == 0.0 || !Mth.equal((double)(absAscend + 1.0), (double)(dist / axis1.length()))) {
                if (axis1.y != 0.0 && axis1.y == -axis2.y) {
                    return info.withMessage("ascending_s_curve");
                }
                info.end1Extent = 0;
                double minHDistance = Math.max(absAscend < 4.0 ? absAscend * 4.0 : absAscend * 3.0, 6.0) / axis1.length();
                if ((double)hDistance < minHDistance) {
                    return info.withMessage("too_steep");
                }
                if ((double)hDistance > minHDistance) {
                    int correction = (int)((double)hDistance - minHDistance);
                    info.end1Extent = maximiseTurn ? 0 : correction / 2 + correction % 2;
                    info.end2Extent = maximiseTurn ? 0 : correction / 2;
                }
                skipCurve = false;
            }
        }
        if (!parallel) {
            boolean ninety;
            float absAngle = Math.abs(AngleHelper.deg((double)angle));
            if (absAngle < 60.0f || absAngle > 300.0f) {
                return info.withMessage("turn_90").tooJumbly();
            }
            intersect = VecHelper.intersect((Vec3)end1, (Vec3)end2, (Vec3)normedAxis1, (Vec3)normedAxis2, (Direction.Axis)Direction.Axis.Y);
            double dist1 = Math.abs(intersect[0]);
            double dist2 = Math.abs(intersect[1]);
            float ex1 = 0.0f;
            float ex2 = 0.0f;
            if (dist1 > dist2) {
                ex1 = (float)((dist1 - dist2) / axis1.length());
            }
            if (dist2 > dist1) {
                ex2 = (float)((dist2 - dist1) / axis2.length());
            }
            double turnSize = Math.min(dist1, dist2) - 0.1;
            boolean bl2 = ninety = (absAngle + 0.25f) % 90.0f < 1.0f;
            if (intersect[0] < 0.0 || intersect[1] < 0.0) {
                return info.withMessage("too_sharp").tooJumbly();
            }
            double minTurnSize = ninety ? 7.0 : 3.25;
            double turnSizeToFitAscend = minTurnSize + (ninety ? Math.max(0.0, absAscend - 3.0) * 2.0 : Math.max(0.0, absAscend - 1.5) * 1.5);
            if (turnSize < minTurnSize) {
                return info.withMessage("too_sharp");
            }
            if (turnSize < turnSizeToFitAscend) {
                return info.withMessage("too_steep");
            }
            if (!maximiseTurn) {
                ex1 = (float)((double)ex1 + (turnSize - turnSizeToFitAscend) / axis1.length());
                ex2 = (float)((double)ex2 + (turnSize - turnSizeToFitAscend) / axis2.length());
            }
            info.end1Extent = Mth.floor((float)ex1);
            info.end2Extent = Mth.floor((float)ex2);
            turnSize = turnSizeToFitAscend;
        }
        Vec3 offset1 = axis1.scale((double)info.end1Extent);
        Vec3 offset2 = axis2.scale((double)info.end2Extent);
        BlockPos targetPos1 = pos1.offset((Vec3i)BlockPos.containing((Position)offset1));
        BlockPos targetPos2 = pos2.offset((Vec3i)BlockPos.containing((Position)offset2));
        info.curve = skipCurve ? null : new BezierConnection((Couple<BlockPos>)Couple.create((Object)targetPos1, (Object)targetPos2), (Couple<Vec3>)Couple.create((Object)end1.add(offset1), (Object)end2.add(offset2)), (Couple<Vec3>)Couple.create((Object)normedAxis1, (Object)normedAxis2), (Couple<Vec3>)Couple.create((Object)normal1, (Object)normal2), true, girder, TrackMaterial.fromItem(stack.getItem()));
        info.valid = true;
        info.pos1 = pos1;
        info.pos2 = pos2;
        info.axis1 = axis1;
        info.axis2 = axis2;
        TrackPlacement.placeTracks(level, info, state1, state2, targetPos1, targetPos2, true);
        ItemStack offhandItem = player.getOffhandItem().copy();
        boolean bl3 = shouldPave = offhandItem.getItem() instanceof BlockItem && !AllTags.AllItemTags.INVALID_FOR_TRACK_PAVING.matches(offhandItem);
        if (shouldPave) {
            BlockItem paveItem = (BlockItem)offhandItem.getItem();
            TrackPlacement.paveTracks(level, info, paveItem, true);
            info.hasRequiredPavement = true;
        }
        info.hasRequiredTracks = true;
        if (!player.isCreative()) {
            for (boolean simulate : Iterate.trueAndFalse) {
                if (level.isClientSide && !simulate) break;
                int tracks = info.requiredTracks;
                int pavement = info.requiredPavement;
                int foundTracks = 0;
                int foundPavement = 0;
                Inventory inv = player.getInventory();
                int size = inv.items.size();
                for (int j = 0; j <= size + 1; ++j) {
                    boolean isTrack;
                    boolean offhand;
                    int i = j;
                    boolean bl4 = offhand = j == size + 1;
                    if (j == size) {
                        i = inv.selected;
                    } else if (offhand) {
                        i = 0;
                    } else if (j == inv.selected) continue;
                    ItemStack stackInSlot = (ItemStack)(offhand ? inv.offhand : inv.items).get(i);
                    boolean bl5 = isTrack = AllTags.AllBlockTags.TRACKS.matches(stackInSlot) && stackInSlot.is(stack.getItem());
                    if (!isTrack && (!shouldPave || offhandItem.getItem() != stackInSlot.getItem()) || (isTrack ? foundTracks >= tracks : foundPavement >= pavement)) continue;
                    int count = stackInSlot.getCount();
                    if (!simulate) {
                        int remainingItems = count - Math.min(isTrack ? tracks - foundTracks : pavement - foundPavement, count);
                        if (i == inv.selected) {
                            stackInSlot.remove(AllDataComponents.TRACK_CONNECTING_FROM);
                        }
                        ItemStack newItem = stackInSlot.copyWithCount(remainingItems);
                        if (offhand) {
                            player.setItemInHand(InteractionHand.OFF_HAND, newItem);
                        } else {
                            inv.setItem(i, newItem);
                        }
                    }
                    if (isTrack) {
                        foundTracks += count;
                        continue;
                    }
                    foundPavement += count;
                }
                if (simulate && foundTracks < tracks) {
                    info.valid = false;
                    info.tooJumbly();
                    info.hasRequiredTracks = false;
                    return info.withMessage("not_enough_tracks");
                }
                if (!simulate || foundPavement >= pavement) continue;
                info.valid = false;
                info.tooJumbly();
                info.hasRequiredPavement = false;
                return info.withMessage("not_enough_pavement");
            }
        }
        if (level.isClientSide()) {
            return info;
        }
        if (shouldPave) {
            BlockItem paveItem = (BlockItem)offhandItem.getItem();
            TrackPlacement.paveTracks(level, info, paveItem, false);
        }
        return TrackPlacement.placeTracks(level, info, state1, state2, targetPos1, targetPos2, false);
    }

    private static void paveTracks(Level level, PlacementInfo info, BlockItem blockItem, boolean simulate) {
        Block block = blockItem.getBlock();
        info.requiredPavement = 0;
        if (block == null || block instanceof EntityBlock || block.defaultBlockState().getCollisionShape((BlockGetter)level, info.pos1).isEmpty()) {
            return;
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        for (boolean first : Iterate.trueAndFalse) {
            int extent = (first ? info.end1Extent : info.end2Extent) + (info.curve != null ? 1 : 0);
            Vec3 axis = first ? info.axis1 : info.axis2;
            BlockPos pavePos = first ? info.pos1 : info.pos2;
            info.requiredPavement += TrackPaver.paveStraight(level, pavePos.below(), axis, extent, block, simulate, visited);
        }
        if (info.curve != null) {
            info.requiredPavement += TrackPaver.paveCurve(level, info.curve, block, simulate, visited);
        }
    }

    private static PlacementInfo placeTracks(Level level, PlacementInfo info, BlockState state1, BlockState state2, BlockPos targetPos1, BlockPos targetPos2, boolean simulate) {
        TrackBlockEntity tte1;
        int requiredTracksForTurn;
        BlockEntity te2;
        block17: {
            block16: {
                info.requiredTracks = 0;
                for (boolean first : Iterate.trueAndFalse) {
                    BlockState state;
                    int extent = first ? info.end1Extent : info.end2Extent;
                    Vec3 axis = first ? info.axis1 : info.axis2;
                    BlockPos pos = first ? info.pos1 : info.pos2;
                    BlockState blockState = state = first ? state1 : state2;
                    if (state.hasProperty((Property)TrackBlock.HAS_BE) && !simulate) {
                        state = (BlockState)state.setValue((Property)TrackBlock.HAS_BE, (Comparable)Boolean.valueOf(false));
                    }
                    switch ((TrackShape)((Object)state.getValue(TrackBlock.SHAPE))) {
                        case TE: 
                        case TW: {
                            state = (BlockState)state.setValue(TrackBlock.SHAPE, (Comparable)((Object)TrackShape.XO));
                            break;
                        }
                        case TN: 
                        case TS: {
                            state = (BlockState)state.setValue(TrackBlock.SHAPE, (Comparable)((Object)TrackShape.ZO));
                            break;
                        }
                    }
                    for (int i = 0; i < (info.curve != null ? extent + 1 : extent); ++i) {
                        boolean canPlace;
                        Vec3 offset = axis.scale((double)i);
                        BlockPos offsetPos = pos.offset((Vec3i)BlockPos.containing((Position)offset));
                        BlockState stateAtPos = level.getBlockState(offsetPos);
                        BlockState toPlace = BlockHelper.copyProperties(state, info.trackMaterial.getBlock().defaultBlockState());
                        boolean bl = canPlace = stateAtPos.canBeReplaced() || stateAtPos.is(BlockTags.FLOWERS);
                        if (canPlace) {
                            ++info.requiredTracks;
                        }
                        if (simulate) continue;
                        Block block = stateAtPos.getBlock();
                        if (block instanceof ITrackBlock) {
                            ITrackBlock trackAtPos = (ITrackBlock)block;
                            toPlace = trackAtPos.overlay((BlockGetter)level, offsetPos, stateAtPos, toPlace);
                            canPlace = true;
                        }
                        if (!canPlace) continue;
                        level.setBlock(offsetPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, toPlace, offsetPos), 3);
                    }
                }
                if (info.curve == null) {
                    return info;
                }
                if (!simulate) {
                    BlockState onto = info.trackMaterial.getBlock().defaultBlockState();
                    BlockState stateAtPos = level.getBlockState(targetPos1);
                    level.setBlock(targetPos1, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)(AllTags.AllBlockTags.TRACKS.matches(stateAtPos) ? stateAtPos : BlockHelper.copyProperties(state1, onto)).setValue((Property)TrackBlock.HAS_BE, (Comparable)Boolean.valueOf(true)), targetPos1), 3);
                    stateAtPos = level.getBlockState(targetPos2);
                    level.setBlock(targetPos2, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)(AllTags.AllBlockTags.TRACKS.matches(stateAtPos) ? stateAtPos : BlockHelper.copyProperties(state2, onto)).setValue((Property)TrackBlock.HAS_BE, (Comparable)Boolean.valueOf(true)), targetPos2), 3);
                }
                BlockEntity te1 = level.getBlockEntity(targetPos1);
                te2 = level.getBlockEntity(targetPos2);
                requiredTracksForTurn = (info.curve.getSegmentCount() + 1) / 2;
                if (!(te1 instanceof TrackBlockEntity)) break block16;
                tte1 = (TrackBlockEntity)te1;
                if (te2 instanceof TrackBlockEntity) break block17;
            }
            info.requiredTracks += requiredTracksForTurn;
            return info;
        }
        TrackBlockEntity tte2 = (TrackBlockEntity)te2;
        if (!tte1.getConnections().containsKey(tte2.getBlockPos())) {
            info.requiredTracks += requiredTracksForTurn;
        }
        if (simulate) {
            return info;
        }
        tte1.addConnection(info.curve);
        tte2.addConnection(info.curve.secondary());
        tte1.tilt.tryApplySmoothing();
        tte2.tilt.tryApplySmoothing();
        return info;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientTick() {
        int i;
        BlockHitResult bhr;
        BlockPos pos;
        LocalPlayer player = Minecraft.getInstance().player;
        ItemStack stack = player.getMainHandItem();
        HitResult hitResult = Minecraft.getInstance().hitResult;
        int restoreWarmup = extraTipWarmup;
        extraTipWarmup = 0;
        if (hitResult == null) {
            return;
        }
        if (hitResult.getType() != HitResult.Type.BLOCK) {
            return;
        }
        InteractionHand hand = InteractionHand.MAIN_HAND;
        if (!AllTags.AllBlockTags.TRACKS.matches(stack)) {
            stack = player.getOffhandItem();
            hand = InteractionHand.OFF_HAND;
            if (!AllTags.AllBlockTags.TRACKS.matches(stack)) {
                return;
            }
        }
        if (!stack.hasFoil()) {
            return;
        }
        TrackBlockItem blockItem = (TrackBlockItem)stack.getItem();
        Level level = player.level();
        BlockState hitState = level.getBlockState(pos = (bhr = (BlockHitResult)hitResult).getBlockPos());
        if (!(hitState.getBlock() instanceof TrackBlock) && !hitState.canBeReplaced()) {
            pos = pos.relative(bhr.getDirection());
            hitState = blockItem.getPlacementState(new UseOnContext((Player)player, hand, bhr));
            if (hitState == null) {
                return;
            }
        }
        if (!(hitState.getBlock() instanceof TrackBlock)) {
            return;
        }
        extraTipWarmup = restoreWarmup;
        boolean maxTurns = Minecraft.getInstance().options.keySprint.isDown();
        PlacementInfo info = TrackPlacement.tryConnect(level, (Player)player, pos, hitState, stack, false, maxTurns);
        if (extraTipWarmup < 20) {
            ++extraTipWarmup;
        }
        if (!info.valid || !hoveringMaxed && (info.end1Extent == 0 || info.end2Extent == 0)) {
            extraTipWarmup = 0;
        }
        if (!(player.isCreative() || !info.valid && info.hasRequiredTracks && info.hasRequiredPavement)) {
            BlueprintOverlayRenderer.displayTrackRequirements(info, player.getOffhandItem());
        }
        if (info.valid) {
            player.displayClientMessage((Component)CreateLang.translateDirect("track.valid_connection", new Object[0]).withStyle(ChatFormatting.GREEN), true);
        } else if (info.message != null) {
            player.displayClientMessage((Component)CreateLang.translateDirect(info.message, new Object[0]).withStyle(info.message.equals("track.second_point") ? ChatFormatting.WHITE : ChatFormatting.RED), true);
        }
        if (bhr.getDirection() == Direction.UP) {
            Vec3 lookVec = player.getLookAngle();
            int lookAngle = (int)(22.5 + (double)(AngleHelper.deg((double)Mth.atan2((double)lookVec.z, (double)lookVec.x)) % 360.0f)) / 8;
            if (!pos.equals((Object)hintPos) || lookAngle != hintAngle) {
                hints = Couple.create(ArrayList::new);
                hintAngle = lookAngle;
                hintPos = pos;
                for (int xOffset = -2; xOffset <= 2; ++xOffset) {
                    for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                        BlockPos offset = pos.offset(xOffset, 0, zOffset);
                        PlacementInfo adjInfo = TrackPlacement.tryConnect(level, (Player)player, offset, hitState, stack, false, maxTurns);
                        ((List)hints.get(adjInfo.valid)).add(offset.below());
                    }
                }
            }
            if (hints != null && !hints.either(Collection::isEmpty)) {
                Outliner.getInstance().showCluster((Object)"track_valid", (Iterable)hints.getFirst()).withFaceTexture((BindableTexture)AllSpecialTextures.THIN_CHECKERED).colored(9817409).lineWidth(0.0f);
                Outliner.getInstance().showCluster((Object)"track_invalid", (Iterable)hints.getSecond()).withFaceTexture((BindableTexture)AllSpecialTextures.THIN_CHECKERED).colored(15359019).lineWidth(0.0f);
            }
        }
        animation.chase(info.valid ? 1.0 : 0.0, 0.25, LerpedFloat.Chaser.EXP);
        animation.tickChaser();
        if (!info.valid) {
            info.end1Extent = 0;
            info.end2Extent = 0;
        }
        int color = Color.mixColors((int)15359019, (int)9817409, (float)animation.getValue());
        Vec3 up = new Vec3(0.0, 0.25, 0.0);
        Vec3 v1 = info.end1;
        Vec3 a1 = info.axis1.normalize();
        Vec3 n1 = info.normal1.cross(a1).scale(0.9375);
        Vec3 o1 = a1.scale(0.125);
        Vec3 ex1 = a1.scale((double)(info.end1Extent - (info.curve == null && info.end1Extent > 0 ? 2 : 0)) * info.axis1.length());
        TrackPlacement.line(1, v1.add(n1).add(up), o1, ex1);
        TrackPlacement.line(2, v1.subtract(n1).add(up), o1, ex1);
        Vec3 v2 = info.end2;
        Vec3 a2 = info.axis2.normalize();
        Vec3 n2 = info.normal2.cross(a2).scale(0.9375);
        Vec3 o2 = a2.scale(0.125);
        Vec3 ex2 = a2.scale((double)info.end2Extent * info.axis2.length());
        TrackPlacement.line(3, v2.add(n2).add(up), o2, ex2);
        TrackPlacement.line(4, v2.subtract(n2).add(up), o2, ex2);
        BezierConnection bc = info.curve;
        if (bc == null) {
            return;
        }
        Vec3 previous1 = null;
        Vec3 previous2 = null;
        int railcolor = color;
        int segCount = bc.getSegmentCount();
        float s = animation.getValue() * 7.0f / 8.0f + 0.125f;
        float lw = animation.getValue() * 1.0f / 16.0f + 0.0625f;
        Vec3 end1 = (Vec3)bc.starts.getFirst();
        Vec3 end2 = (Vec3)bc.starts.getSecond();
        Vec3 finish1 = end1.add(((Vec3)bc.axes.getFirst()).scale(bc.getHandleLength()));
        Vec3 finish2 = end2.add(((Vec3)bc.axes.getSecond()).scale(bc.getHandleLength()));
        String key = "curve";
        for (i = 0; i <= segCount; ++i) {
            float t = (float)i / (float)segCount;
            Vec3 result = VecHelper.bezier((Vec3)end1, (Vec3)end2, (Vec3)finish1, (Vec3)finish2, (float)t);
            Vec3 derivative = VecHelper.bezierDerivative((Vec3)end1, (Vec3)end2, (Vec3)finish1, (Vec3)finish2, (float)t).normalize();
            Vec3 normal = bc.getNormal(t).cross(derivative).scale(0.9375);
            Vec3 rail1 = result.add(normal).add(up);
            Vec3 rail2 = result.subtract(normal).add(up);
            if (previous1 != null) {
                Vec3 middle1 = rail1.add(previous1).scale(0.5);
                Vec3 middle2 = rail2.add(previous2).scale(0.5);
                Outliner.getInstance().showLine((Object)Pair.of((Object)key, (Object)(i * 2)), VecHelper.lerp((float)s, (Vec3)middle1, (Vec3)previous1), VecHelper.lerp((float)s, (Vec3)middle1, (Vec3)rail1)).colored(railcolor).disableLineNormals().lineWidth(lw);
                Outliner.getInstance().showLine((Object)Pair.of((Object)key, (Object)(i * 2 + 1)), VecHelper.lerp((float)s, (Vec3)middle2, (Vec3)previous2), VecHelper.lerp((float)s, (Vec3)middle2, (Vec3)rail2)).colored(railcolor).disableLineNormals().lineWidth(lw);
            }
            previous1 = rail1;
            previous2 = rail2;
        }
        for (i = segCount + 1; i <= lastLineCount; ++i) {
            Outliner.getInstance().remove((Object)Pair.of((Object)key, (Object)(i * 2)));
            Outliner.getInstance().remove((Object)Pair.of((Object)key, (Object)(i * 2 + 1)));
        }
        lastLineCount = segCount;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void line(int id, Vec3 v1, Vec3 o1, Vec3 ex) {
        int color = Color.mixColors((int)15359019, (int)9817409, (float)animation.getValue());
        Outliner.getInstance().showLine((Object)Pair.of((Object)"start", (Object)id), v1.subtract(o1), v1.add(ex)).lineWidth(0.125f).disableLineNormals().colored(color);
    }

    static {
        animation = LerpedFloat.linear().startWithValue(0.0);
        lastLineCount = 0;
    }

    public static class PlacementInfo {
        BezierConnection curve = null;
        boolean valid = false;
        int end1Extent = 0;
        int end2Extent = 0;
        String message = null;
        public int requiredTracks = 0;
        public boolean hasRequiredTracks = false;
        public int requiredPavement = 0;
        public boolean hasRequiredPavement = false;
        public final TrackMaterial trackMaterial;
        Vec3 end1;
        Vec3 end2;
        Vec3 normal1;
        Vec3 normal2;
        Vec3 axis1;
        Vec3 axis2;
        BlockPos pos1;
        BlockPos pos2;

        public PlacementInfo(TrackMaterial material) {
            this.trackMaterial = material;
        }

        public PlacementInfo withMessage(String message) {
            this.message = "track." + message;
            return this;
        }

        public PlacementInfo tooJumbly() {
            this.curve = null;
            return this;
        }
    }

    public record ConnectingFrom(BlockPos pos, Vec3 axis, Vec3 normal, Vec3 end) {
        public static final Codec<ConnectingFrom> CODEC = RecordCodecBuilder.create(i -> i.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(ConnectingFrom::pos), (App)Vec3.CODEC.fieldOf("axis").forGetter(ConnectingFrom::axis), (App)Vec3.CODEC.fieldOf("normal").forGetter(ConnectingFrom::normal), (App)Vec3.CODEC.fieldOf("end").forGetter(ConnectingFrom::end)).apply((Applicative)i, ConnectingFrom::new));
        public static final StreamCodec<ByteBuf, ConnectingFrom> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ConnectingFrom::pos, (StreamCodec)CatnipStreamCodecs.VEC3, ConnectingFrom::axis, (StreamCodec)CatnipStreamCodecs.VEC3, ConnectingFrom::normal, (StreamCodec)CatnipStreamCodecs.VEC3, ConnectingFrom::end, ConnectingFrom::new);
    }
}

